/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.internal.core.github;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.github.IGithubOrganization;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.internal.core.github.GithubAPI;
import com.aptana.git.internal.core.github.GithubRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GithubOrganization
implements IGithubOrganization {
    private static final String LOGIN = "login";
    private static final String ID = "id";
    private static final String URL = "url";
    private JSONObject json;

    public GithubOrganization(JSONObject json) {
        this.json = json;
    }

    @Override
    public long getID() {
        if (!this.json.containsKey((Object)ID)) {
            return -1L;
        }
        return (Long)this.json.get((Object)ID);
    }

    @Override
    public String getName() {
        return (String)this.json.get((Object)LOGIN);
    }

    @Override
    public String getURL() {
        return (String)this.json.get((Object)URL);
    }

    @Override
    public List<IGithubRepository> getRepos() throws CoreException {
        List result = (List)this.getAPI().get("orgs/" + this.getName() + "/repos");
        ArrayList<IGithubRepository> repoURLs = new ArrayList<IGithubRepository>(result.size());
        for (JSONObject repo : result) {
            repoURLs.add(new GithubRepository(repo));
        }
        return repoURLs;
    }

    protected GithubAPI getAPI() {
        return new GithubAPI(GitPlugin.getDefault().getGithubManager().getUser());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.getID() ^ this.getID() >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GithubOrganization)) {
            return false;
        }
        GithubOrganization other = (GithubOrganization)obj;
        return this.getID() == other.getID();
    }
}

